package nemosofts.voxradio.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;

import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.Home.AdapterHome;
import nemosofts.voxradio.asyncTask.LoadHome;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.InvalidUserDialog;
import nemosofts.voxradio.fragment.Search.FragmentSearch;
import nemosofts.voxradio.interfaces.HomeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.helper.Helper;

public class FragmentHome extends Fragment {

    DBHelper dbHelper;
    Helper helper;
    ProgressBar progressBar;
    FrameLayout frameLayout;
    RecyclerView rv_home;
    AdapterHome adapterHome;
    ArrayList<ItemPost> arrayList;
    private String errr_msg;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_home, container, false);
        setHasOptionsMenu(true);

        helper = new Helper(getActivity());

        arrayList = new ArrayList<>();
        dbHelper = new DBHelper(getActivity());

        progressBar = rootView.findViewById(R.id.pb_home);
        frameLayout = rootView.findViewById(R.id.fl_empty);

        rv_home = rootView.findViewById(R.id.rv_home);
        LinearLayoutManager llm = new LinearLayoutManager(getActivity());
        rv_home.setLayoutManager(llm);
        rv_home.setItemAnimator(new DefaultItemAnimator());
        rv_home.setHasFixedSize(true);

        loadHome();

        return rootView;
    }

    private void loadHome() {
        if (helper.isNetworkAvailable()) {
            LoadHome loadHome = new LoadHome(new HomeListener() {
                @Override
                public void onStart() {
                    frameLayout.setVisibility(View.GONE);
                    rv_home.setVisibility(View.GONE);
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd(String success, String message, ArrayList<ItemPost> arrayListPost) {
                    if (getActivity() != null) {
                        if (success.equals("1")) {

                            if (Callback.arrayList_play.isEmpty() && !arrayListPost.isEmpty()) {
                                for (int i = 0; i < arrayListPost.size(); i++) {
                                    if(!arrayListPost.get(i).getArrayListRadio().isEmpty()) {
                                        Callback.arrayList_play.addAll(arrayListPost.get(i).getArrayListRadio());
                                        try {
                                            GlobalBus.getBus().postSticky(Callback.arrayList_play.get(0));
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        break;
                                    }
                                }
                            }

                            if (!arrayListPost.isEmpty()){

                                arrayList.addAll(arrayListPost);

                                adapterHome = new AdapterHome(getActivity(), arrayListPost);
                                rv_home.setAdapter(adapterHome);
                                setEmpty();
                            } else {
                                errr_msg = getString(R.string.err_no_data_found);
                                setEmpty();
                            }

                        } else if (success.equals("-2")) {
                            new InvalidUserDialog(getActivity(),message);
                        } else {
                            errr_msg = getString(R.string.err_server);
                            setEmpty();
                        }
                        progressBar.setVisibility(View.GONE);
                    }
                }
            }, helper.getAPIRequest(Callback.METHOD_HOME, 0, dbHelper.getRecentIDs("10"), "", "", "", "", "", "", "", "", "", "", "", null));
            loadHome.execute();
        } else {
            errr_msg = getString(R.string.err_internet_not_connected);
            setEmpty();
        }
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            rv_home.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
            progressBar.setVisibility(View.GONE);
        } else {
            rv_home.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
            progressBar.setVisibility(View.INVISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) requireActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> loadHome());

            frameLayout.addView(myView);
        }
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        menu.clear();
        inflater.inflate(R.menu.menu_search, menu);
        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        SearchView searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
        super.onCreateOptionsMenu(menu, inflater);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            Callback.search_item = s.replace(" ", "%20");
            FragmentSearch fsearch = new FragmentSearch();
            FragmentManager fm = getParentFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(fm.findFragmentByTag(getString(R.string.nav_home)));
            ft.add(R.id.fragment, fsearch, getString(R.string.search));
            ft.addToBackStack(getString(R.string.search));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    @SuppressLint("NotifyDataSetChanged")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onEquilizerChange(ItemCat itemCat) {
        adapterHome.onEqualizerChange();
        GlobalBus.getBus().removeStickyEvent(itemCat);
    }

    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }

}